<?php $__env->startSection('content'); ?>
<!-- Hero Section -->
<section class="hero-section relative min-h-screen flex items-center justify-center overflow-hidden">
    <!-- Background Image: Luxury skyline/cityscape representing investment -->
    <div class="absolute inset-0">
        <img src="https://images.unsplash.com/photo-1486406146926-c627a92ad1ab?w=1920&q=80"
             alt="Luxury Real Estate Investment"
             class="w-full h-full object-cover">
    </div>
    <!-- Dark overlay for text readability -->
    <div class="absolute inset-0 bg-gradient-to-br from-blue-900/70 via-blue-800/60 to-gray-900/70"></div>

    <div class="relative z-10 text-center text-white px-4 max-w-6xl mx-auto">
        <h1 class="text-5xl md:text-7xl font-bold mb-6 leading-tight">
            Welcome to
            <span class="block text-amber-400">Ispace Homes</span>
        </h1>
        <p class="text-xl md:text-2xl mb-8 text-gray-200 max-w-3xl mx-auto">
            Discover exclusive luxury properties with exceptional rental yields and zero taxation. Your gateway to premium real estate investments.
        </p>

        <div class="flex flex-col sm:flex-row gap-4 justify-center items-center mb-12">
            <button onclick="document.getElementById('inquiry-modal').classList.remove('hidden'); document.getElementById('inquiry-modal').classList.add('flex')"
                    class="bg-amber-500 hover:bg-amber-600 text-white font-bold py-4 px-8 rounded-lg text-lg transition-all transform hover:scale-105 shadow-lg">
                Request Information
            </button>
            <a href="https://wa.me/<?php echo e(config('services.whatsapp.number', '1234567890')); ?>?text=Hi, I'm interested in Ispace Homes properties"
               target="_blank"
               class="bg-white hover:bg-gray-100 text-blue-900 font-bold py-4 px-8 rounded-lg text-lg transition-all transform hover:scale-105 shadow-lg">
                WhatsApp Us
            </a>
        </div>

        <?php if($featuredProperties->isNotEmpty()): ?>
            <div class="text-sm text-gray-300">
                <p>Featured Property: <?php echo e($featuredProperties->first()->name); ?></p>
                <p class="text-2xl font-bold text-amber-400 mt-2">Starting from <?php echo e($featuredProperties->first()->formatted_price); ?></p>
            </div>
        <?php endif; ?>
    </div>

    <div class="absolute bottom-8 left-1/2 transform -translate-x-1/2 animate-bounce">
        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3"/>
        </svg>
    </div>
</section>

<!-- Investment Benefits Section -->
<section class="py-20 bg-gradient-to-br from-gray-900 via-blue-900 to-gray-900">
    <div class="container mx-auto px-4">
        <h2 class="text-4xl md:text-5xl font-bold text-center text-white mb-12">
            Why Invest with Us
        </h2>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 max-w-6xl mx-auto">
            <div class="bg-white bg-opacity-10 backdrop-blur-lg rounded-lg p-8 text-center border border-white border-opacity-20 hover:bg-opacity-20 transition-all">
                <div class="w-16 h-16 bg-amber-500 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-white mb-3">High Rental Yields</h3>
                <p class="text-gray-300">Earn 8-10% annual rental returns on your investment with guaranteed income streams.</p>
            </div>

            <div class="bg-white bg-opacity-10 backdrop-blur-lg rounded-lg p-8 text-center border border-white border-opacity-20 hover:bg-opacity-20 transition-all">
                <div class="w-16 h-16 bg-amber-500 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-white mb-3">Zero Taxation</h3>
                <p class="text-gray-300">Benefit from 0% income tax, 0% capital gains tax, and 0% property tax.</p>
            </div>

            <div class="bg-white bg-opacity-10 backdrop-blur-lg rounded-lg p-8 text-center border border-white border-opacity-20 hover:bg-opacity-20 transition-all">
                <div class="w-16 h-16 bg-amber-500 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-white mb-3">Prime Locations</h3>
                <p class="text-gray-300">Properties in world-class destinations with exceptional growth potential.</p>
            </div>
        </div>
    </div>
</section>

<?php if($brandedProperties->isNotEmpty()): ?>
<!-- Brand Partnerships Section -->
<section class="py-20 bg-white">
    <div class="container mx-auto px-4">
        <h2 class="text-4xl md:text-5xl font-bold text-center text-gray-900 mb-4">
            Luxury Brand Collaborations
        </h2>
        <p class="text-center text-gray-600 mb-12 max-w-3xl mx-auto">
            Experience properties designed by world-renowned luxury brands
        </p>

        <?php $__currentLoopData = $brandedProperties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand => $properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="mb-16">
            <h3 class="text-3xl font-bold text-center mb-8 text-blue-900"><?php echo e($brand); ?></h3>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-<?php echo e($properties->count() > 2 ? '3' : '2'); ?> gap-8 max-w-6xl mx-auto">
                <?php $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="property-card group cursor-pointer bg-white rounded-lg overflow-hidden shadow-lg hover:shadow-2xl transition-all transform hover:-translate-y-2">
                    <div class="relative overflow-hidden h-64">
                        <img src="<?php echo e($property->image); ?>" alt="<?php echo e($property->name); ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                        <div class="absolute top-4 right-4 bg-amber-500 text-white px-3 py-1 rounded-full text-sm font-semibold">
                            <?php echo e($property->brand_partnership); ?>

                        </div>
                        <?php if($property->rental_yield): ?>
                        <div class="absolute top-4 left-4 bg-green-500 text-white px-3 py-1 rounded-full text-sm font-semibold">
                            <?php echo e($property->rental_yield); ?>% ROI
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="p-6">
                        <h4 class="text-xl font-bold text-gray-900 mb-2"><?php echo e($property->name); ?></h4>
                        <p class="text-gray-600 text-sm mb-3"><?php echo e($property->location); ?></p>
                        <p class="text-gray-700 mb-4 line-clamp-2"><?php echo e($property->description); ?></p>
                        <div class="flex justify-between items-center mb-4">
                            <div class="text-sm text-gray-600">
                                <span class="font-semibold"><?php echo e($property->bedrooms); ?></span> Beds •
                                <span class="font-semibold"><?php echo e($property->bathrooms); ?></span> Baths •
                                <span class="font-semibold"><?php echo e(number_format($property->size)); ?></span> <?php echo e($property->size_unit); ?>

                            </div>
                        </div>
                        <div class="flex justify-between items-center">
                            <div class="text-2xl font-bold text-blue-900"><?php echo e($property->formatted_price); ?></div>
                            <button onclick="openInquiry(<?php echo e($property->id); ?>)" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors">
                                Inquire
                            </button>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</section>
<?php endif; ?>

<!-- All Properties Section -->
<section class="py-20 bg-gray-100">
    <div class="container mx-auto px-4">
        <h2 class="text-4xl md:text-5xl font-bold text-center text-gray-900 mb-4">
            Featured Properties
        </h2>
        <p class="text-center text-gray-600 mb-12 max-w-3xl mx-auto">
            Explore our exclusive collection of luxury properties
        </p>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 max-w-7xl mx-auto">
            <?php $__currentLoopData = $allProperties->take(8); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="property-card group cursor-pointer bg-white rounded-lg overflow-hidden shadow-lg hover:shadow-2xl transition-all transform hover:-translate-y-2">
                <div class="relative overflow-hidden h-48">
                    <img src="<?php echo e($property->image); ?>" alt="<?php echo e($property->name); ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                    <?php if($property->brand_partnership): ?>
                    <div class="absolute top-3 right-3 bg-amber-500 text-white px-2 py-1 rounded-full text-xs font-semibold">
                        <?php echo e($property->brand_partnership); ?>

                    </div>
                    <?php endif; ?>
                </div>
                <div class="p-4">
                    <h4 class="text-lg font-bold text-gray-900 mb-1"><?php echo e($property->name); ?></h4>
                    <p class="text-gray-600 text-xs mb-2"><?php echo e($property->location); ?></p>
                    <div class="text-xs text-gray-600 mb-3">
                        <?php echo e($property->bedrooms); ?> Beds • <?php echo e($property->bathrooms); ?> Baths
                    </div>
                    <div class="flex justify-between items-center">
                        <div class="text-lg font-bold text-blue-900"><?php echo e($property->formatted_price); ?></div>
                        <button onclick="openInquiry(<?php echo e($property->id); ?>)" class="bg-blue-600 text-white px-3 py-1 rounded-md text-sm hover:bg-blue-700 transition-colors">
                            Inquire
                        </button>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Call to Action Section -->
<section class="py-20 bg-gradient-to-br from-blue-900 via-blue-800 to-gray-900 text-white">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-4xl md:text-5xl font-bold mb-6">
            Ready to Invest in Your Future?
        </h2>
        <p class="text-xl mb-8 text-gray-200 max-w-3xl mx-auto">
            Our expert team is ready to guide you through every step of your investment journey.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center items-center">
            <button onclick="document.getElementById('inquiry-modal').classList.remove('hidden'); document.getElementById('inquiry-modal').classList.add('flex')"
                    class="bg-amber-500 hover:bg-amber-600 text-white font-bold py-4 px-8 rounded-lg text-lg transition-all transform hover:scale-105 shadow-lg">
                Get Started Today
            </button>
            <a href="tel:<?php echo e(config('services.phone.number', '+1234567890')); ?>"
               class="bg-white hover:bg-gray-100 text-blue-900 font-bold py-4 px-8 rounded-lg text-lg transition-all transform hover:scale-105 shadow-lg">
                Call Us Now
            </a>
        </div>
    </div>
</section>

<script>
function openInquiry(propertyId = null) {
    const modal = document.getElementById('inquiry-modal');
    modal.classList.remove('hidden');
    modal.classList.add('flex');

    if (propertyId) {
        const form = document.getElementById('inquiry-form');
        let propertyInput = form.querySelector('input[name="property_id"]');
        if (!propertyInput) {
            propertyInput = document.createElement('input');
            propertyInput.type = 'hidden';
            propertyInput.name = 'property_id';
            form.appendChild(propertyInput);
        }
        propertyInput.value = propertyId;
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/elias/devops/laravel/ispace/resources/views/home.blade.php ENDPATH**/ ?>