<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: linear-gradient(135deg, #0a1628 0%, #243dae 100%);
            color: white;
            padding: 30px;
            text-align: center;
            border-radius: 8px 8px 0 0;
        }
        .content {
            background: #f8f9fa;
            padding: 30px;
            border: 1px solid #dee2e6;
        }
        .detail-row {
            margin: 15px 0;
            padding: 10px;
            background: white;
            border-left: 4px solid #243dae;
            border-radius: 4px;
        }
        .label {
            font-weight: bold;
            color: #243dae;
            display: inline-block;
            width: 120px;
        }
        .value {
            color: #333;
        }
        .footer {
            background: #0a1628;
            color: white;
            padding: 20px;
            text-align: center;
            border-radius: 0 0 8px 8px;
            font-size: 12px;
        }
        .property-info {
            background: #d4af37;
            color: white;
            padding: 15px;
            margin: 15px 0;
            border-radius: 6px;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1 style="margin: 0;">New Property Inquiry</h1>
        <p style="margin: 10px 0 0 0;">You have received a new inquiry from your website</p>
    </div>

    <div class="content">
        <h2 style="color: #243dae; margin-top: 0;">Contact Information</h2>

        <div class="detail-row">
            <span class="label">Name:</span>
            <span class="value">{{ $inquiry->title ? $inquiry->title . ' ' : '' }}{{ $inquiry->name }}</span>
        </div>

        <div class="detail-row">
            <span class="label">Email:</span>
            <span class="value"><a href="mailto:{{ $inquiry->email }}">{{ $inquiry->email }}</a></span>
        </div>

        <div class="detail-row">
            <span class="label">Phone:</span>
            <span class="value"><a href="tel:{{ $inquiry->phone }}">{{ $inquiry->phone }}</a></span>
        </div>

        @if($inquiry->property_id && $inquiry->property)
        <div class="property-info">
            <strong>Property of Interest:</strong><br>
            {{ $inquiry->property->name }}<br>
            <small>{{ $inquiry->property->location }} - {{ $inquiry->property->formatted_price }}</small>
        </div>
        @endif

        @if($inquiry->message)
        <div class="detail-row" style="border-left-color: #d4af37;">
            <span class="label" style="color: #d4af37; width: 100%; display: block; margin-bottom: 10px;">Message:</span>
            <span class="value" style="display: block;">{{ $inquiry->message }}</span>
        </div>
        @endif

        <div class="detail-row">
            <span class="label">Submitted:</span>
            <span class="value">{{ $inquiry->created_at->format('F j, Y g:i A') }}</span>
        </div>

        <div class="detail-row">
            <span class="label">Inquiry ID:</span>
            <span class="value">#{{ $inquiry->id }}</span>
        </div>
    </div>

    <div class="footer">
        <p style="margin: 0;">This inquiry was submitted through Ispace Properties website.</p>
        <p style="margin: 10px 0 0 0;">Please respond to the customer within 24 hours.</p>
    </div>
</body>
</html>
