<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: linear-gradient(135deg, #0a1628 0%, #243dae 100%);
            color: white;
            padding: 40px 30px;
            text-align: center;
            border-radius: 8px 8px 0 0;
        }
        .content {
            background: white;
            padding: 30px;
            border: 1px solid #dee2e6;
        }
        .highlight-box {
            background: #f8f9fa;
            border-left: 4px solid #d4af37;
            padding: 20px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .cta-button {
            display: inline-block;
            background: #d4af37;
            color: white;
            padding: 15px 30px;
            text-decoration: none;
            border-radius: 6px;
            font-weight: bold;
            margin: 20px 0;
        }
        .footer {
            background: #0a1628;
            color: white;
            padding: 30px;
            text-align: center;
            border-radius: 0 0 8px 8px;
        }
        .contact-info {
            margin: 15px 0;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 6px;
        }
        .property-detail {
            background: #d4af37;
            color: white;
            padding: 20px;
            margin: 20px 0;
            border-radius: 6px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1 style="margin: 0; font-size: 28px;">Thank You for Your Inquiry!</h1>
        <p style="margin: 10px 0 0 0; font-size: 16px;">We've received your inquiry and our team will contact you shortly</p>
    </div>

    <div class="content">
        <p style="font-size: 16px;">Dear {{ $inquiry->title ? $inquiry->title . ' ' : '' }}{{ $inquiry->name }},</p>

        <p>Thank you for your interest in Ispace Homes luxury real estate properties. We have received your inquiry and our dedicated team will review it carefully.</p>

        <div class="highlight-box">
            <strong style="color: #243dae; font-size: 18px;">What Happens Next?</strong>
            <ul style="margin: 15px 0; padding-left: 20px;">
                <li>Our property consultant will review your inquiry</li>
                <li>We'll contact you within 24 hours</li>
                <li>We'll provide detailed information and answer all your questions</li>
                <li>Schedule a viewing if you're interested</li>
            </ul>
        </div>

        @if($inquiry->property_id && $inquiry->property)
        <div class="property-detail">
            <strong style="font-size: 18px; display: block; margin-bottom: 10px;">Property You Inquired About:</strong>
            <div style="font-size: 20px; margin-bottom: 5px;">{{ $inquiry->property->name }}</div>
            <div style="opacity: 0.9;">
                📍 {{ $inquiry->property->location }}
                @if($inquiry->property->bedrooms)
                    <br>🛏️ {{ $inquiry->property->bedrooms }} Bedrooms • {{ $inquiry->property->bathrooms }} Bathrooms
                @endif
                <br>💰 {{ $inquiry->property->formatted_price }}
                @if($inquiry->property->rental_yield)
                    <br>📈 {{ $inquiry->property->rental_yield }}% Annual ROI
                @endif
            </div>
        </div>
        @endif

        <div class="contact-info">
            <strong style="color: #243dae;">Your Inquiry Details:</strong><br>
            <small style="color: #666;">
                Inquiry ID: #{{ $inquiry->id }}<br>
                Submitted: {{ $inquiry->created_at->format('F j, Y g:i A') }}
            </small>
        </div>

        <p style="margin-top: 25px;">In the meantime, feel free to contact us directly:</p>

        <div style="text-align: center; margin: 30px 0;">
            <a href="https://wa.me/{{ config('services.whatsapp.number') }}?text=Hi, I submitted inquiry #{{ $inquiry->id }}" class="cta-button" style="margin-right: 10px;">
                💬 WhatsApp Us
            </a>
            <a href="tel:{{ config('services.phone.number') }}" class="cta-button">
                📞 Call Us
            </a>
        </div>

        <p>We look forward to helping you find your perfect property!</p>

        <p style="margin-top: 30px;">
            Best regards,<br>
            <strong style="color: #243dae;">The Ispace Homes Team</strong>
        </p>
    </div>

    <div class="footer">
        <p style="margin: 0; font-size: 16px;"><strong>Contact Us</strong></p>
        <p style="margin: 10px 0;">
            📧 {{ config('mail.from.address') }}<br>
            📱 {{ config('services.phone.number') }}
        </p>
        <p style="margin: 20px 0 0 0; font-size: 12px; opacity: 0.8;">
            This is an automated response. Please do not reply to this email directly.<br>
            If you need immediate assistance, please contact us through the methods above.
        </p>
    </div>
</body>
</html>
