import './bootstrap';

// Modal functionality
document.addEventListener('DOMContentLoaded', function() {
    const inquiryModal = document.getElementById('inquiry-modal');
    const inquiryModalTrigger = document.getElementById('inquiry-modal-trigger');
    const closeModal = document.getElementById('close-modal');
    const inquiryForm = document.getElementById('inquiry-form');
    const submitBtn = document.getElementById('submit-btn');
    const formMessage = document.getElementById('form-message');

    // Open modal
    if (inquiryModalTrigger) {
        inquiryModalTrigger.addEventListener('click', function() {
            inquiryModal.classList.remove('hidden');
            inquiryModal.classList.add('flex');
        });
    }

    // Close modal
    if (closeModal) {
        closeModal.addEventListener('click', function() {
            inquiryModal.classList.add('hidden');
            inquiryModal.classList.remove('flex');
            inquiryForm.reset();
            formMessage.classList.add('hidden');
        });
    }

    // Close modal when clicking outside
    inquiryModal?.addEventListener('click', function(e) {
        if (e.target === inquiryModal) {
            inquiryModal.classList.add('hidden');
            inquiryModal.classList.remove('flex');
            inquiryForm.reset();
            formMessage.classList.add('hidden');
        }
    });

    // Form submission
    if (inquiryForm) {
        inquiryForm.addEventListener('submit', async function(e) {
            e.preventDefault();

            // Disable submit button
            submitBtn.disabled = true;
            submitBtn.textContent = 'Submitting...';
            formMessage.classList.add('hidden');

            // Get form data
            const formData = new FormData(inquiryForm);
            const data = Object.fromEntries(formData.entries());

            try {
                const response = await fetch('/inquiries', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    body: JSON.stringify(data)
                });

                const result = await response.json();

                if (response.ok) {
                    formMessage.textContent = result.message || 'Thank you for your inquiry. We will contact you shortly.';
                    formMessage.classList.remove('hidden', 'text-red-600');
                    formMessage.classList.add('text-green-600');
                    inquiryForm.reset();

                    // Close modal after 2 seconds
                    setTimeout(() => {
                        inquiryModal.classList.add('hidden');
                        inquiryModal.classList.remove('flex');
                        formMessage.classList.add('hidden');
                    }, 2000);
                } else {
                    let errorMessage = 'An error occurred. Please try again.';
                    if (result.errors) {
                        errorMessage = Object.values(result.errors).flat().join(', ');
                    } else if (result.message) {
                        errorMessage = result.message;
                    }
                    formMessage.textContent = errorMessage;
                    formMessage.classList.remove('hidden', 'text-green-600');
                    formMessage.classList.add('text-red-600');
                }
            } catch (error) {
                console.error('Error:', error);
                formMessage.textContent = 'Network error. Please check your connection and try again.';
                formMessage.classList.remove('hidden', 'text-green-600');
                formMessage.classList.add('text-red-600');
            } finally {
                submitBtn.disabled = false;
                submitBtn.textContent = 'Submit Inquiry';
            }
        });
    }
});
