<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PropertySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $properties = [
            [
                'name' => 'Palazzo Versace Residences',
                'description' => 'Experience unparalleled luxury in these exclusive Versace-designed residences. Featuring bespoke interiors, world-class amenities, and breathtaking waterfront views. Every detail crafted to perfection by the legendary Italian fashion house.',
                'property_type' => 'apartment',
                'price' => 926000,
                'currency' => 'USD',
                'location' => 'Dubai Creek Harbour',
                'area' => 'Culture Village',
                'bedrooms' => 3,
                'bathrooms' => 4,
                'size' => 2450,
                'size_unit' => 'sqft',
                'image' => 'https://images.unsplash.com/photo-1512917774080-9991f1c4c750?w=1200',
                'featured' => true,
                'brand_partnership' => 'Versace',
                'rental_yield' => 8.5,
                'completion_date' => '2026-12-31',
                'amenities' => 'Private Beach, Infinity Pool, Spa & Wellness Center, 24/7 Concierge, Valet Parking',
                'is_active' => true,
            ],
            [
                'name' => 'Cavalli Tower',
                'description' => 'Indulge in the epitome of sophistication at Cavalli Tower. This architectural masterpiece showcases Roberto Cavalli\'s signature style with opulent finishes, designer furnishings, and exclusive amenities that redefine luxury living.',
                'property_type' => 'penthouse',
                'price' => 1850000,
                'currency' => 'USD',
                'location' => 'Dubai Marina',
                'area' => 'Marina Promenade',
                'bedrooms' => 4,
                'bathrooms' => 5,
                'size' => 4200,
                'size_unit' => 'sqft',
                'image' => 'https://images.unsplash.com/photo-1600596542815-ffad4c1539a9?w=1200',
                'featured' => true,
                'brand_partnership' => 'Roberto Cavalli',
                'rental_yield' => 7.8,
                'completion_date' => '2025-06-30',
                'amenities' => 'Private Elevator, Rooftop Terrace, Jacuzzi, Home Automation, Smart Security',
                'is_active' => true,
            ],
            [
                'name' => 'de GRISOGONO Luxury Apartments',
                'description' => 'Discover the brilliance of de GRISOGONO in these stunning residences. Featuring jewel-inspired design elements, premium materials, and exceptional craftsmanship that mirrors the brand\'s renowned luxury jewelry.',
                'property_type' => 'apartment',
                'price' => 675000,
                'currency' => 'USD',
                'location' => 'Downtown Dubai',
                'area' => 'Business Bay',
                'bedrooms' => 2,
                'bathrooms' => 3,
                'size' => 1850,
                'size_unit' => 'sqft',
                'image' => 'https://images.unsplash.com/photo-1613490493576-7fde63acd811?w=1200',
                'featured' => true,
                'brand_partnership' => 'de GRISOGONO',
                'rental_yield' => 9.2,
                'completion_date' => '2025-09-30',
                'amenities' => 'Crystal Chandelier Lobby, Diamond-Cut Pool, Jewel Spa, Fine Dining Restaurant',
                'is_active' => true,
            ],
            [
                'name' => 'Waterfront Villas Collection',
                'description' => 'Immerse yourself in coastal elegance with these exclusive waterfront villas. Boasting private beach access, contemporary architecture, and panoramic sea views that create an idyllic sanctuary for discerning homeowners.',
                'property_type' => 'villa',
                'price' => 2450000,
                'currency' => 'USD',
                'location' => 'Palm Jumeirah',
                'area' => 'Frond M',
                'bedrooms' => 6,
                'bathrooms' => 7,
                'size' => 8500,
                'size_unit' => 'sqft',
                'image' => 'https://images.unsplash.com/photo-1564013799919-ab600027ffc6?w=1200',
                'featured' => true,
                'brand_partnership' => null,
                'rental_yield' => 6.5,
                'completion_date' => '2025-12-31',
                'amenities' => 'Private Beach, Swimming Pool, Landscaped Garden, Maid\'s Room, Home Cinema',
                'is_active' => true,
            ],
            [
                'name' => 'Metropolitan Townhouses',
                'description' => 'Modern townhouses designed for contemporary family living. Featuring spacious layouts, private gardens, and smart home technology in a vibrant community with world-class facilities.',
                'property_type' => 'townhouse',
                'price' => 548000,
                'currency' => 'USD',
                'location' => 'Arabian Ranches',
                'area' => 'Ranches 3',
                'bedrooms' => 3,
                'bathrooms' => 4,
                'size' => 2200,
                'size_unit' => 'sqft',
                'image' => 'https://images.unsplash.com/photo-1580587771525-78b9dba3b914?w=1200',
                'featured' => false,
                'brand_partnership' => null,
                'rental_yield' => 7.5,
                'completion_date' => '2026-03-31',
                'amenities' => 'Community Pool, Parks, Retail Center, Schools, Golf Course Access',
                'is_active' => true,
            ],
            [
                'name' => 'Sky Gardens Residences',
                'description' => 'Elevated living at its finest. These contemporary apartments feature private sky gardens, floor-to-ceiling windows, and stunning city skyline views, creating a perfect urban oasis.',
                'property_type' => 'apartment',
                'price' => 425000,
                'currency' => 'USD',
                'location' => 'Jumeirah Lake Towers',
                'area' => 'Cluster Y',
                'bedrooms' => 2,
                'bathrooms' => 2,
                'size' => 1450,
                'size_unit' => 'sqft',
                'image' => 'https://images.unsplash.com/photo-1545324418-cc1a3fa10c00?w=1200',
                'featured' => false,
                'brand_partnership' => null,
                'rental_yield' => 8.8,
                'completion_date' => '2025-08-31',
                'amenities' => 'Gym, Swimming Pool, Children\'s Play Area, BBQ Area, Covered Parking',
                'is_active' => true,
            ],
            [
                'name' => 'The Luxe Collection',
                'description' => 'Premium apartments offering sophisticated design and luxury finishes. Located in the heart of the city with easy access to shopping, dining, and entertainment destinations.',
                'property_type' => 'apartment',
                'price' => 186000,
                'currency' => 'USD',
                'location' => 'International City',
                'area' => 'England Cluster',
                'bedrooms' => 1,
                'bathrooms' => 1,
                'size' => 750,
                'size_unit' => 'sqft',
                'image' => 'https://images.unsplash.com/photo-1522708323590-d24dbb6b0267?w=1200',
                'featured' => false,
                'brand_partnership' => null,
                'rental_yield' => 10.5,
                'completion_date' => '2025-05-31',
                'amenities' => 'Swimming Pool, Gym, Security, Parking, Central A/C',
                'is_active' => true,
            ],
            [
                'name' => 'Emerald Gardens Villas',
                'description' => 'Luxurious villas nestled in lush landscaping, offering privacy and tranquility. Each villa features contemporary design, smart home integration, and premium outdoor living spaces.',
                'property_type' => 'villa',
                'price' => 1680000,
                'currency' => 'USD',
                'location' => 'Dubai Hills Estate',
                'area' => 'Parkway',
                'bedrooms' => 5,
                'bathrooms' => 6,
                'size' => 6200,
                'size_unit' => 'sqft',
                'image' => 'https://images.unsplash.com/photo-1600607687939-ce8a6c25118c?w=1200',
                'featured' => true,
                'brand_partnership' => null,
                'rental_yield' => 6.8,
                'completion_date' => '2026-06-30',
                'amenities' => 'Private Pool, Garden, Golf Course Views, Smart Home, Multi-Car Garage',
                'is_active' => true,
            ],
        ];

        foreach ($properties as $property) {
            \App\Models\Property::create($property);
        }
    }
}
