<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Property extends Model
{
    protected $fillable = [
        'name',
        'description',
        'property_type',
        'price',
        'currency',
        'location',
        'area',
        'bedrooms',
        'bathrooms',
        'size',
        'size_unit',
        'image',
        'gallery',
        'featured',
        'brand_partnership',
        'rental_yield',
        'completion_date',
        'amenities',
        'is_active',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'size' => 'decimal:2',
        'rental_yield' => 'decimal:2',
        'gallery' => 'array',
        'featured' => 'boolean',
        'is_active' => 'boolean',
        'completion_date' => 'date',
    ];

    public function inquiries()
    {
        return $this->hasMany(Inquiry::class);
    }

    public function getFormattedPriceAttribute()
    {
        return $this->currency . ' ' . number_format($this->price, 0);
    }
}
