<?php

namespace App\Http\Controllers;

use App\Mail\InquiryAutoReply;
use App\Mail\InquiryReceived;
use App\Models\Inquiry;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class InquiryController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'nullable|in:Mr,Mrs,Ms,Dr',
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:20',
            'property_id' => 'nullable|exists:properties,id',
            'message' => 'nullable|string|max:1000',
        ]);

        $inquiry = Inquiry::create($validated);
        $inquiry->load('property');

        // Send notification email to admin
        if (config('mail.admin_email')) {
            Mail::to(config('mail.admin_email'))->send(new InquiryReceived($inquiry));
        }

        // Send auto-reply to customer
        Mail::to($inquiry->email)->send(new InquiryAutoReply($inquiry));

        return response()->json([
            'success' => true,
            'message' => 'Thank you for your inquiry. Our team will contact you shortly.',
            'inquiry_id' => $inquiry->id,
        ], 201);
    }
}
