<?php

namespace App\Http\Controllers;

use App\Models\Property;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $featuredProperties = Property::where('featured', true)
            ->where('is_active', true)
            ->orderBy('price', 'desc')
            ->get();

        $brandedProperties = Property::whereNotNull('brand_partnership')
            ->where('is_active', true)
            ->get()
            ->groupBy('brand_partnership');

        $allProperties = Property::where('is_active', true)
            ->orderBy('created_at', 'desc')
            ->get();

        return view('home', compact('featuredProperties', 'brandedProperties', 'allProperties'));
    }
}
